<?php
include "session.php";
include "header.php"; // Inclui o menu de navegação

// Captura o ID do filme
$id = $_GET["id"];
if (empty($id)) {
    header("Location: moviesondemand.php");
    exit;
}

// Configuração TMDb
$tmdb_api_key = "95497bb6942dfa426d495f9350f011b9"; 
$userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) IPTV_Player_Pro';

// Função para requisições API
function getApiData($url) {
    global $userAgent;
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_USERAGENT      => $userAgent,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT        => 10
    ]);
    
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true) ?: [];
}

// Dados do Xtream Codes
$xtream_url = $get_dns . "/player_api.php?username=" . $username . "&password=" . $password . "&action=get_vod_info&vod_id=" . $id;
$channel_api = getApiData($xtream_url);

$info = $channel_api["info"] ?? [];
$movie_data = $channel_api["movie_data"] ?? [];

$title               = $info["name"] ?? 'Título Indisponível';
$description         = $info["plot"] ?? 'Sinopse não disponível para este título.';
$youtube_trailer     = $info["youtube_trailer"] ?? '';
$movie_genre         = $info["genre"] ?? 'Geral';
$releasedate         = $info["releasedate"] ?? 'N/A';
$movie_rating        = $info["rating"] ?? '0.0';
$container_extension = $movie_data["container_extension"] ?? 'mp4';
$backdrop            = $info["backdrop_path"][0] ?? '';
$img                 = !empty($info["movie_image"]) ? $info["movie_image"] : "https://i.imgur.com/Mn7aXQD.jpg";

// Busca Elenco no TMDb
$cast_list = '';
$tmdb_search_url = "https://api.themoviedb.org/3/search/movie?api_key={$tmdb_api_key}&query=" . urlencode($title);
$tmdb_movie_data = getApiData($tmdb_search_url);
$tmdb_movie_id = $tmdb_movie_data['results'][0]['id'] ?? null;

if ($tmdb_movie_id) {
    $tmdb_cast_url = "https://api.themoviedb.org/3/movie/{$tmdb_movie_id}/credits?api_key={$tmdb_api_key}";
    $cast_data = getApiData($tmdb_cast_url);
    $cast = $cast_data['cast'] ?? [];
    
    foreach (array_slice($cast, 0, 6) as $actor) {
        $actor_img = !empty($actor["profile_path"]) 
            ? "https://image.tmdb.org/t/p/w200" . $actor["profile_path"] 
            : "https://www.themoviedb.org/assets/2/v4/glyphicons/basic/glyphicons-basic-4-68148d6a993889ee5390e11502476ef8f73100b3ee137cad16738c8236209581.svg";
        
        $cast_list .= "
            <div class='actor-card'>
                <img src='{$actor_img}' alt='{$actor["name"]}'>
                <span class='name'>".htmlspecialchars($actor["name"])."</span>
                <span class='char'>".htmlspecialchars($actor["character"])."</span>
            </div>";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $title; ?> - Detalhes</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;800&display=swap');
        
        :root {
            --primary: #e50914;
            --primary-hover: #ff1f29;
            --bg-dark: #080a0f;
            --glass: rgba(18, 22, 33, 0.8);
            --border: rgba(255, 255, 255, 0.1);
        }

        body {
            margin: 0; padding: 0; min-height: 100vh;
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: var(--bg-dark); color: #fff;
            overflow-x: hidden;
        }

        /* Plano de Fundo Dinâmico */
        .bg-blur {
            position: fixed; inset: 0;
            background: url('<?php echo $backdrop; ?>') no-repeat center center fixed;
            background-size: cover;
            filter: blur(30px) brightness(0.2) saturate(1.5);
            z-index: -2;
        }

        .bg-overlay {
            position: fixed; inset: 0;
            background: radial-gradient(circle at top right, rgba(229,9,20,0.15), transparent 50%),
                        linear-gradient(to bottom, transparent, var(--bg-dark));
            z-index: -1;
        }

        .content-wrapper {
            display: flex; justify-content: center; align-items: center;
            min-height: 100vh; padding: 60px 20px; box-sizing: border-box;
        }

        .movie-container {
            display: flex; flex-wrap: wrap; gap: 50px;
            background: var(--glass);
            backdrop-filter: blur(25px);
            border: 1px solid var(--border);
            border-radius: 40px;
            padding: 50px;
            max-width: 1100px; width: 100%;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.8);
            animation: fadeIn 0.8s ease-out;
        }

        @keyframes fadeIn { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }

        .poster-section { flex: 1 1 300px; max-width: 320px; }
        .poster-section img {
            width: 100%; border-radius: 24px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.5);
            border: 1px solid rgba(255,255,255,0.1);
        }

        .movie-details { flex: 2 1 400px; }
        .movie-details h1 { font-size: clamp(2rem, 5vw, 3rem); font-weight: 800; margin: 0 0 15px 0; letter-spacing: -1px; }

        .meta-tags { display: flex; flex-wrap: wrap; gap: 10px; margin-bottom: 25px; }
        .tag {
            background: rgba(255,255,255,0.08); padding: 6px 14px; border-radius: 10px;
            font-size: 0.85rem; font-weight: 600; border: 1px solid var(--border);
        }
        .tag.rating { color: #ffd700; border-color: rgba(255, 215, 0, 0.3); }

        .description { font-size: 1.05rem; line-height: 1.7; color: #d1d5db; margin-bottom: 35px; }

        .buttons-group { display: flex; flex-wrap: wrap; gap: 15px; margin-bottom: 40px; }
        .btn {
            padding: 16px 32px; border-radius: 16px; font-size: 1.1rem; font-weight: 700;
            text-decoration: none; cursor: pointer; transition: 0.3s; border: none;
            display: inline-flex; align-items: center; gap: 10px;
        }
        .btn-watch { background: var(--primary); color: #fff; box-shadow: 0 10px 20px rgba(229, 9, 20, 0.3); }
        .btn-watch:hover { background: var(--primary-hover); transform: translateY(-3px); }
        .btn-trailer { background: rgba(255,255,255,0.1); color: #fff; border: 1px solid var(--border); }
        .btn-trailer:hover { background: rgba(255,255,255,0.2); }

        .cast-title { font-size: 1.1rem; font-weight: 700; margin-bottom: 20px; border-left: 4px solid var(--primary); padding-left: 10px; }
        .cast-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(90px, 1fr)); gap: 15px; }
        .actor-card { text-align: center; }
        .actor-card img { width: 65px; height: 65px; border-radius: 50%; object-fit: cover; border: 2px solid var(--border); margin-bottom: 8px; }
        .actor-card .name { font-size: 0.8rem; font-weight: 700; display: block; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; }
        .actor-card .char { font-size: 0.7rem; color: #9ca3af; display: block; }

        /* Modal */
        .modal {
            display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.95);
            z-index: 2000; align-items: center; justify-content: center; backdrop-filter: blur(10px);
        }
        .modal-content { width: 90%; max-width: 900px; aspect-ratio: 16/9; position: relative; }
        .close-modal { position: absolute; top: -40px; right: 0; font-size: 30px; color: #fff; cursor: pointer; }

        @media (max-width: 850px) {
            .movie-container { padding: 30px; }
            .poster-section { max-width: 200px; margin: 0 auto; }
            .movie-details h1 { text-align: center; }
            .meta-tags, .buttons-group { justify-content: center; }
        }
    </style>
</head>
<body>

<div class="bg-blur"></div>
<div class="bg-overlay"></div>

<div class="content-wrapper">
    <div class="movie-container">
        <div class="poster-section">
            <img src="<?php echo $img; ?>" alt="<?php echo $title; ?>">
        </div>
        
        <div class="movie-details">
            <h1><?php echo $title; ?></h1>
            
            <div class="meta-tags">
                <span class="tag"><?php echo $releasedate; ?></span>
                <span class="tag"><?php echo $movie_genre; ?></span>
                <span class="tag rating">⭐ <?php echo $movie_rating; ?>/10</span>
            </div>
            
            <div class="description"><?php echo $description; ?></div>
            
            <div class="buttons-group">
                <a href="video_player?id=<?php echo $id; ?>&slug=movie&ext=<?php echo $container_extension; ?>" class="btn btn-watch">
                    Assista Agora
                </a>
                <?php if(!empty($youtube_trailer)): ?>
                    <button class="btn btn-trailer" id="openModal">Trailer</button>
                <?php endif; ?>
            </div>
            
            <?php if(!empty($cast_list)): ?>
                <div class="cast-title">Elenco Principal</div>
                <div class="cast-grid">
                    <?php echo $cast_list; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div id="trailerModal" class="modal">
    <div class="modal-content">
        <span class="close-modal" id="closeModal">&times;</span>
        <iframe width="100%" height="100%" src="https://www.youtube.com/embed/<?php echo $youtube_trailer; ?>" frameborder="0" allowfullscreen></iframe>
    </div>
</div>

<script>
    const modal = document.getElementById('trailerModal');
    const btn = document.getElementById('openModal');
    const span = document.getElementById('closeModal');

    if(btn) {
        btn.onclick = () => modal.style.display = 'flex';
        span.onclick = () => modal.style.display = 'none';
        window.onclick = (e) => { if (e.target == modal) modal.style.display = 'none'; }
    }
</script>

</body>
</html>